/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.session;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.annotation.WillClose;

public class KeyUtil {
    public static byte[] loadPem(Path file) throws IOException {
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            byte[] byArray = KeyUtil.loadPem(is);
            return byArray;
        }
    }

    public static byte[] loadPem(byte[] bytes) throws IOException {
        return KeyUtil.loadPem(new ByteArrayInputStream(bytes));
    }

    public static byte[] loadPem(@WillClose InputStream is) throws IOException {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("--")) continue;
                builder.append(line);
            }
        }
        return Base64.getDecoder().decode(builder.toString());
    }

    public static PrivateKey loadPrivateKeyPem(Path path) throws IOException {
        return KeyUtil.loadPrivateKey(KeyUtil.loadPem(path));
    }

    public static PrivateKey loadPrivateKeyPem(InputStream is) throws IOException {
        return KeyUtil.loadPrivateKey(KeyUtil.loadPem(is));
    }

    public static PrivateKey loadPrivateKeyPem(byte[] bytes) throws IOException {
        return KeyUtil.loadPrivateKey(KeyUtil.loadPem(bytes));
    }

    public static PrivateKey loadPrivateKey(byte[] key) {
        try {
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(key);
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            return keyFactory.generatePrivate(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException ex) {
            throw new RuntimeException("Failed to load private key.", ex);
        }
    }

    public static PublicKey loadPublicKeyPem(Path path) throws IOException {
        return KeyUtil.loadPublicKey(KeyUtil.loadPem(path));
    }

    public static PublicKey loadPublicKeyPem(InputStream is) throws IOException {
        return KeyUtil.loadPublicKey(KeyUtil.loadPem(is));
    }

    public static PublicKey loadPublicKeyPem(byte[] bytes) throws IOException {
        return KeyUtil.loadPublicKey(KeyUtil.loadPem(bytes));
    }

    public static PublicKey loadPublicKey(byte[] key) {
        try {
            X509EncodedKeySpec spec = new X509EncodedKeySpec(key);
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            return keyFactory.generatePublic(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException ex) {
            throw new RuntimeException("Failed to load public key.", ex);
        }
    }
}

